var seedPluton,seedVolcan,seedFG,seedFD,seedCoul;
var tActions=[];
var phase=0;

var tCoul=["#C8C800","#FFE099","#EDA9BC","#C87C5B","#777777"
		,"#4B0082","#000000"];
		
function reinit (canv) {
	videCanv(canv);
	videCanv(canvTemp);
	sedim(canv,15,4,true);
	let nivJ=joueur.readNiv();
	if (nivJ>=4) {
		enableBut ("butEro");
	}
	if (nivJ>=5) {
		enableBut ("butFailleN");
		enableBut ("butFailleN2");
		enableBut ("butFailleI");
		enableBut ("butFailleI2");
	}
	if (nivJ>=7) {
		enableBut ("butPluton");
	}
	if (nivJ>=8) {
		enableBut ("butVolcan");
	}
	if (nivJ>=2) {
		enableBut ("butPli");
	}
}

function volcan (canv,x,prof) {
	if ((hintVolcan)&&(phase==1)&&(lastHint=="butVolcan")) {
		hintVolcan=false;
		hideId("divDoigt");
	}
	if (saveAff) {tAff[iAff].push({t:"vol",x:x,p:prof});}
	tActions[phase].push("vol");
	
	if (x<0) {
		x=random(seedVolcan)*60+20;
	}
	
	if (prof<0) {
		prof=random(seedVolcan)*5+5;
	}
	seedVolcan++;

	let ct = canv.getContext('2d');
	ct.save();
	
	
	// création du pattern du volcan
	var l=160;
	var h=80;
	var x1=l*0.2;
	var x2=x1+l*0.5;
	var y1=h*0.2;
	var y2=y1+h*0.5;
	var rx=l*0.4;
	canvPat.width=0;
	canvPat.width=l;
	canvPat.height=h;
	ctPat.strokeStyle="#F0F";
	ctPat.fillStyle="#4B0082";
	ctPat.fillRect(0,0,l,h);
	
	// dessin du motif du volcan
	// lignes horiz
	ctPat.beginPath();
	ctPat.moveTo(x1,y1);
	ctPat.lineTo(x1+rx,y1);

	ctPat.moveTo(x2,y2);
	ctPat.lineTo(x2+rx,y2);
	ctPat.lineWidth=4;
	ctPat.stroke();
	

	var fs = ctTemp.createPattern(canvPat, "repeat");

	chambre (canv,x,prof,10,1.1,0.8,fs,"#4B0082");

	//sedim(canvG,2,5);
	let y=lowerYatX(canv,x);
	x=x/100*lCanv;
	
	prof=prof/100*hCanv;
	let yy=lowerY(canv)+prof+hCanv*0.1-h*1.8;
	ct.fillStyle="#4B0082";
	ct.fillRect(x-15,y,30,yy-y);
	// dessin cone
	
	let r=lCanv*0.04;
	videCanv(canvTemp);
	ctTemp.fillStyle="#4B0082";
	ctTemp.beginPath();
	ctTemp.moveTo (x,y-r);
	ctTemp.lineTo (x-r*2,y+r);
	ctTemp.lineTo (x+r*2,y+r);
	ctTemp.lineTo (x,y-r);
	ctTemp.closePath();
	ctTemp.fill();
	
	ctTemp.drawImage(canv,0,0);
	videCanv(canv);
	ct.drawImage(canvTemp,0,0);
	
	ct.restore();
}


function chambre (canv,x,prof,r,rAura,ecr,fs,coul) {
	let ct = canv.getContext('2d');
	videCanv(canvTemp);
	ctTemp.save();
	ctTemp.scale (1/ecr,1);
				
	x=x/100*lCanv;
	prof=prof/100*hCanv;
	r=hCanv*r/100;
	let y=lowerY(canv)+prof;
		
	ctTemp.beginPath();
	ctTemp.arc(x*ecr,y+r,r*rAura,0,Math.PI*2);

	let rcol=parseInt(coul[1]+coul[2],16);
	let gcol=parseInt(coul[3]+coul[4],16);
	let bcol=parseInt(coul[5]+coul[6],16);


	// degradé autour
	var grd=ctTemp.createRadialGradient(x*ecr, y+r, r, x*ecr, y+r, r*rAura);
	grd.addColorStop(0, "rgba("+rcol+","+gcol+","+bcol+",0.6)");
	grd.addColorStop(1, "rgba("+rcol+","+gcol+","+bcol+",0)");
	
	ctTemp.fillStyle=grd;
	ctTemp.fill();
	
	// chambre
	ctTemp.beginPath();
	ctTemp.arc(x*ecr,y+r,r,0,Math.PI*2);
	ctTemp.fillStyle=fs;
	ctTemp.fill();
	
	
	ct.globalCompositeOperation = 'source-atop';
	ct.drawImage(canvTemp,0,0);
	ct.globalCompositeOperation = 'source-over';
	
	ctTemp.restore();
}

function pluton (canv,x,prof,r,noSave) {
	if ((hintPluton)&&(phase==1)&&(lastHint=="butPluton")) {
		hintPluton=false;
		hideId("divDoigt");
	}
	
	noSave=noSave||false;
	if ((!noSave)&&(saveAff)) {tAff[iAff].push({t:"plu",x:x,p:prof,r:r});}
	if (!noSave) {tActions[phase].push("plu");}
	
	if (x<0) {
		x=random(seedPluton)*60+20;
	}
	
	if (prof<0) {
		prof=random(seedPluton)*5+5;
	}
	seedPluton++;
	

	// création du pattern du pluton
	var l=160;
	var h=80;
	var x1=l*0.2;
	var x2=x1+l*0.5;
	var y1=h*0.2;
	var y2=y1+h*0.5;
	var rx=l*0.1;
	var ry=h*0.1;
	canvPat.width=0;
	canvPat.width=l;
	canvPat.height=h;
	ctPat.strokeStyle="white";
	ctPat.fillStyle="#BB0000";
	ctPat.fillRect(0,0,l,h);
	
	// dessin du motif du pluton
	// lignes horiz
	ctPat.beginPath();
	ctPat.moveTo(x1-rx,y1);
	ctPat.lineTo(x1+rx,y1);

	ctPat.moveTo(x2-rx,y2);
	ctPat.lineTo(x2+rx,y2);
	ctPat.lineWidth=4;
	ctPat.stroke();
	
	//lignes vertic
	ctPat.beginPath();

	ctPat.moveTo(x1,y1-ry);
	ctPat.lineTo(x1,y1+ry);

	ctPat.moveTo(x2,y2-ry);
	ctPat.lineTo(x2,y2+ry);
	ctPat.lineWidth=8;
	ctPat.stroke();
	
	let ct = canv.getContext('2d');
	ct.save();
	
	var pattern = ctTemp.createPattern(canvPat, "repeat");
	
	chambre (canv,x,prof,r,4,2,pattern,"#BB0000");
	
	ct.restore();
}

function failleN(canv,x,pente,h) {
	if ((hintFaille)&&(phase==1)) {
		if ((lastHint=="butFailleI")||(lastHint=="butFailleI2")||(lastHint=="butFailleN")||(lastHint=="butFailleN2")) {
			hintFaille=false;
			hideId("divDoigt");
		}
	}
	if (saveAff) {tAff[iAff].push({t:"fn1",x:x,p:pente,h:h});}
	tActions[phase].push("fn1");
	failleG (canv,x,pente,h);
}

function failleN2(canv,x,pente,h) {
	if (saveAff) {tAff[iAff].push({t:"fn2",x:x,p:pente,h:h});}
	tActions[phase].push("fn2");
	failleD (canv,x,pente,h);
}

function failleI(canv,x,pente,h) {
	tActions[phase].push("fi1");
	if (saveAff) {tAff[iAff].push({t:"fi1",x:x,p:pente,h:h});}
	failleG (canv,x,pente,-h);
}

function failleI2(canv,x,pente,h) {
	if (saveAff) {tAff[iAff].push({t:"fi2",x:x,p:pente,h:h});}
	tActions[phase].push("fi2");
	failleD (canv,x,pente,-h);
}


function failleG (canv,x,pente,h) {
	if (x<0) {
		if (modeLibre) {
			x=random(seedFG)*80+5;
		} else {
			x=random(seedFG)*20+5;
		}
	}
	
	seedFG++;
	
	let ct = canv.getContext('2d');
	ct.save();
	ctTemp.save();
	
	// x et h en %
	x=x/100*lCanv;
	h=h/100*hCanv;
	let x2=x+hCanv*pente;
	let dx=h*pente-1;
	
	videCanv(canvTemp);
	
	// on copie sur canvTemp
	ctTemp.drawImage(canv,0,0);

	// création du masque 
	ct.beginPath();
	ct.moveTo(x,0);
	ct.lineTo(x2,hCanv);
	ct.lineTo(lCanv,hCanv);
	ct.lineTo(lCanv,0);
	ct.lineTo(x,0);
	ct.closePath();
	
	// on efface
	ct.globalCompositeOperation = 'destination-out';
	ct.fillStyle = 'white';
	ct.fill();
	
	ct.globalCompositeOperation = 'source-over';
	
	// masque complémentaire 
	ctTemp.beginPath();
	ctTemp.moveTo(x,0);
	ctTemp.lineTo(x2,hCanv);
	ctTemp.lineTo(0,hCanv);
	ctTemp.lineTo(0,0);
	ctTemp.lineTo(x,0);
	ctTemp.closePath();
	
	// on efface

	ctTemp.globalCompositeOperation = 'destination-out';
	ctTemp.fillStyle = 'white';
	ctTemp.fill();
	ctTemp.globalCompositeOperation = 'source-over';
	
	ct.drawImage(canvTemp,dx,h);	

	
	// tracé trait
	ct.lineWidth=2;
	ct.globalCompositeOperation = 'source-atop';
	ct.strokeStyle="black";
	ct.beginPath();
	ct.moveTo(x,0);
	ct.lineTo(x2,hCanv);
	ct.stroke();
	ctTemp.globalCompositeOperation = 'source-over';
	
	ct.restore();
	ctTemp.restore();
}


function failleD (canv,x,pente,h) {
	if (x<0) {
		if (modeLibre) {
			x=random(seedFD)*80+10;
		} else {
			x=random(seedFD)*20+75;
		}
	}
	
	seedFD++;
	
	let ct = canv.getContext('2d');
	
	ct.save();
	ctTemp.save();
	
	// x et h en %
	x=x/100*lCanv;
	h=h/100*hCanv;
	let x2=x-hCanv*pente;
	let dx=-h*pente-1;
	
	videCanv(canvTemp);
	
	// on copie sur canvTemp
	ctTemp.drawImage(canv,0,0);

	// création du masque 
	ct.beginPath();
	ct.moveTo(x,0);
	ct.lineTo(x2,hCanv);
	ct.lineTo(0,hCanv);
	ct.lineTo(0,0);
	ct.lineTo(x,0);
	ct.closePath();
	
	// on efface
	ct.globalCompositeOperation = 'destination-out';
	ct.fillStyle = 'white';
	ct.fill();
	ct.globalCompositeOperation = 'source-over';
	

	// masque complémentaire 
	ctTemp.beginPath();
	ctTemp.moveTo(x,0);
	ctTemp.lineTo(x2,hCanv);
	ctTemp.lineTo(lCanv,hCanv);
	ctTemp.lineTo(lCanv,0);
	ctTemp.lineTo(x,0);
	ctTemp.closePath();
	
	// on efface
	ctTemp.globalCompositeOperation = 'destination-out';
	ctTemp.fillStyle = 'white';
	ctTemp.fill();
	ctTemp.globalCompositeOperation = 'source-over';
	
	ct.drawImage(canvTemp,dx+2,h);	
	
	// tracé trait
	ct.save();
	ct.lineWidth=2;
	ct.globalCompositeOperation = 'source-atop';
	ct.strokeStyle="black";
	ct.beginPath();
	ct.moveTo(x,0);
	ct.lineTo(x2,hCanv);
	ct.stroke();
	ct.globalCompositeOperation = 'source-over';
	
	
	ct.restore();
	ctTemp.restore();
}


function ondule (canv) {
	if ((hintPli)&&(phase==1)&&(lastHint=="butPli")) {
		hintPli=false;
		hideId("divDoigt");
	}
	if (saveAff) {tAff[iAff].push({t:"pli"});}
	tActions[phase].push("pli");
	let h=hCanv*0.04;
	videCanv(canvTemp);
	var l=5;
	let ct = canv.getContext('2d');
	for (let i=0;i<lCanv;i+=l) {
		ctTemp.drawImage(canv, i,0,l,hCanv ,i,Math.sin(i/lCanv*10)*h,l,hCanv);
	}
	videCanv(canv);
	let dx=lCanv*dComp;
	ct.drawImage(canvTemp,0,0,lCanv,hCanv, dx, 0,lCanv-dx*2,hCanv);	
}

function sedim (canv,h,coul,noSave) {
	noSave=noSave||false;

	if ((hintSedim==true)&&(phase==1)&&(noSave===false)) {
		hintSedim=false;	
		hideId("divDoigt");
	}
	if ((!noSave)&&(saveAff)) {tAff[iAff].push({t:"sed",h:h,c:coul});}
	
	if (coul<0) {
		coul=Math.floor(random(seedCoul)*4);
	}
	
	if (noSave==false) {tActions[phase].push("sed"+coul);}
	
	seedCoul++;
	
	
	// création du pattern
	var l=80;
	
	canvPat.width=0;
	canvPat.width=l;
	canvPat.height=l;
	ctPat.strokeStyle="white";
	ctPat.fillStyle=tCoul[coul];
	ctPat.fillRect(0,0,l,l);
	
	// dessin du motif 
	if (coul==0) { // petits traits horizontaux
		var x1=l*0.2;
		var x2=x1+l*0.5;
		var y1=l*0.1;
		var y2=y1+l*0.5;
		var rx=l*0.1;
		ctPat.beginPath();
		ctPat.moveTo(x1-rx,y1);
		ctPat.lineTo(x1+rx,y1);

		ctPat.moveTo(x2-rx,y2);
		ctPat.lineTo(x2+rx,y2);
		ctPat.lineWidth=4;
		ctPat.stroke();
	}
	
	if (coul==1) {
		var x1=l*0.2;
		var x2=x1+l*0.5;
		var y1=2;
		var y2=l*0.5;
		var y3=l-2;
		ctPat.beginPath();
		ctPat.moveTo(0,y1);
		ctPat.lineTo(lCanv,y1);
		ctPat.moveTo(0,y2);
		ctPat.lineTo(lCanv,y2);

		ctPat.moveTo(x1,y1);
		ctPat.lineTo(x1,y2);
		
		ctPat.moveTo(x2,y2);
		ctPat.lineTo(x2,y3);
		
		ctPat.lineWidth=4;
		ctPat.stroke();		
	}
	
	if (coul==2) {
		ctPat.fillStyle="white";
		let n=3;
		for (var i=-1;i<n;i++) {
			for (var j=-1;j<n;j++) {
				let x=i/n*l;
				let y=j/n*l;
				ctPat.fillRect (x-2,y-2,4,4);
				ctPat.fillRect (x-2+l/n/2,y-2+l/n/2,4,4);
			}
		}
	}
	
	if (coul==3) {
		ctPat.lineWidth=2;
		let n=2;
		let r=l/20;
		for (var i=-1;i<n;i++) {
			for (var j=-1;j<n;j++) {
				let x=i/n*l+l/n/2;
				let y=j/n*l+l/n/2;
				ctPat.beginPath();
				ctPat.arc(x,y,r,0,Math.PI*2);
				ctPat.stroke();
				ctPat.beginPath();
				ctPat.arc(x+l/n/2,y+l/n/2,r,0,Math.PI*2);
				ctPat.stroke();
			}
		}
	}
	
	let ct = canv.getContext('2d');
	var pattern = ctTemp.createPattern(canvPat, "repeat");	
	
	// h en %
	h=h/100*hCanv;
	let y=lowerY(canv);
	videCanv(canvTemp);
	ctTemp.drawImage(canv, 0, 0);
	videCanv(canv);
	ct.fillStyle=pattern;
	ct.fillRect(0,y-h,lCanv,h);
	ct.strokeStyle="black";
	ct.lineWidth=2;
	ct.strokeRect(0,y-h,lCanv,h);
	ct.drawImage(canvTemp, 0, 0);	
}

function erode (canv,h) {
	if ((hintPluton)&&(phase==1)&&(lastHint=="butEro")) {
		hintErosion=false;
		hideId("divDoigt");
	}
	if (saveAff) {tAff[iAff].push({t:"ero",h:h});}
	tActions[phase].push("ero");
	let ct = canv.getContext('2d');
	ct.save();
	// h en %
	h=Math.round(h/100*hCanv);
	let y=higherY(canv);
	ct.clearRect(0,y,lCanv,h);
	
	// ligne
	y+=h+1;
	ct.fillStyle="black";
	ct.globalCompositeOperation = 'source-atop';
	ct.lineWidth=2;
	ct.beginPath();
	ct.moveTo(0,y);
	ct.lineTo(lCanv,y);
	ct.stroke();
	ct.restore();
}

function nextGoodAction () {
	let l0=tActions[0].length;
	let l1=tActions[1].length;
	if (JSON.stringify(tActions[0]) === JSON.stringify(tActions[1])) {return "valide";}
	
	if (l1<l0) { // moins d'actions que prévu
		let a0=tActions[0].slice(0,l1);
		if (JSON.stringify(a0) != JSON.stringify(tActions[1])) {
			return "erreur";
		} 
		// on recherche la prochaine action
		return tActions[0][l1];
	}
	
	if (l1>l0) { // le joueur a fait trop d'actions
		return "erreur";
	}
	
	return "erreur";
}