var lastHint="";
var noIntro=false;
var noTime=false;
var hintSedim=true;
var hintValid=true;
var hintPli=true;
var hintPluton=true;
var hintVolcan=true;
var hintErosion=true;
var hintFaille=true;
var joueur;
var timeLeft=60;
var timeMax=60;
const dComp=0.03;
var numVerifAff=0;
var seed=0;
var seedBis=0;

var byId = function( id ) { return document.getElementById( id ); };
var hideId = function (id) {document.getElementById( id ).style.display="none";}
var showId = function (id) {document.getElementById( id ).style.display="block";}
var showLineId = function (id) {document.getElementById( id ).style.display="inline-block";}
var toggleId = function (id) {if (document.getElementById( id ).style.display=="block") {document.getElementById( id ).style.display="none";} else { document.getElementById( id ).style.display="block";}}
var hide = function (d) {d.style.display="none";}
var show = function (d) {d.style.display="block";}
var showLine = function (d) {d.style.display="inline-block";}
var toggle = function (d) {if (d.style.display=="block") {d.style.display="none";} else {d.style.display="block";}}

var lMain,hMain;
var divMain,canvG,ctG,canvD,ctD,canvTemp,ctTemp,canvComp1,canvComp2,ctComp1,ctComp2,canvComp,ctComp;
var canvPat,ctPat;
var hCanv=1500;
var lCanv=1500;


var tImages=["sablier.png","tete_lyell.png","bulleBD.png","croquis-lyell.jpg","ok-icon.png","skull-icon.png", "principes.jpg","puzzle-terre.png","finger.png","capture.jpg","strates.jpg","carte-icon.png","gomme.png","marteau.png","ammonite.png","faille-normale.jpg","failleI1.png","failleI2.png","failleN1.png","failleN2.png","failles.jpg","pli.jpg","pli-entier.jpg","pli-erosion.jpg","pluton.png","sad.png","sisyphe.png","sortie-geol.jpg","volcan.png","affleurement-p-thomas.jpg","enigme-geologique.jpg","clipart-geologue.png"];
var iImage=0;
var tImagesCache=[];

function getPosInMain (d,center) {
	var boxMain=divMain.getBoundingClientRect();
	var box=d.getBoundingClientRect();
	var x=box.x-boxMain.x;
	var y=box.y-boxMain.y;
	if (center) {
		x+=box.width/2;
		y+=box.height/2;
	}
	return {x:Math.round(x),y:Math.round(y)};
}

function recommencer () {
	phase=1;
	let vies;
	if (!modeLibre) {
		vies=joueur.readVies();
		if (vies<=0) {return false;}
	}
	tActions[1]=[];
	joueur.downVies();
	if (!modeLibre) {
		vies=joueur.readVies();
		if (vies==0) {disableBut("butReset");}
		updateVies();
		timeLeft=timeMax;
	}
	initSeeds();
	reinit(canvD);
}
		
function initDiv () {
	divMain=byId("divMain");
	canvG=byId("canvG");
	ctG = canvG.getContext('2d');
	videCanv(canvG);
	canvD=byId("canvD");
	ctD = canvD.getContext('2d');
	videCanv(canvD);
	canvComp1=document.createElement('canvas');
	canvComp2=document.createElement('canvas');
	ctComp1=canvComp1.getContext('2d');
	ctComp2=canvComp2.getContext('2d');
	videCanv(canvComp1);
	videCanv(canvComp2);
	
	canvComp=byId("canvComp");
	ctComp=canvComp.getContext('2d');
	videCanv(canvComp);
	
	canvTemp=document.createElement('canvas');
	ctTemp=canvTemp.getContext('2d');
	videCanv(canvTemp);
	
	canvPat=document.createElement('canvas');
	ctPat=canvPat.getContext('2d');
	
	byId("spanCol1").style.backgroundColor=tCoul[0];
	byId("spanCol2").style.backgroundColor=tCoul[1];
	byId("spanCol3").style.backgroundColor=tCoul[2];
	byId("spanCol4").style.backgroundColor=tCoul[3];
	
	window.addEventListener("resize", redim);
}

function initSeeds () {
	//console.log ("initSeeds");
	if (saveAff) {
		iAff=0;
		if (seed==0) {seed=Math.round(Math.random()*1000);}
		seedPluton=seed;
		seedVolcan=seed+10;
		seedFG=seed+20;
		seedFD=seed+30;
		seedCoul=seed+40;
		tAff[0]=[{seed:seed}];
	} else {
		var aff=tAff[iAff];
		seed=aff[0].seed;
		if (seed<0) {seed=seedBis;}
		seedPluton=seed;
		seedVolcan=seed+10;
		seedFG=seed+20;
		seedFD=seed+30;
		seedCoul=seed+40;
	}
}


function initSituation (n) {
	//console.log ("initSituation");
	tActions[0]=[];
	tActions[1]=[];
	seedBis=Math.round(Math.random()*100000);
	iAff=n;
	if (!modeLibre) {
		if ((n<0)||(n>=tAff.length)) {return false;}
	}
	// sous couche indispensable
	reinit(canvG);
	reinit(canvD);
	initSeeds ();
	phase=0;
	if (saveAff) {return false;}
	//
	//saveAff=true;
	//iAff=2;
	//tAff[iAff]=[];
	//return false;
	let nivJ=joueur.readNiv();
	var aff=tAff[iAff];
	var niv=aff[0].niv;
	byId("divMap").innerHTML=niv;
	var tpsLong=(aff.length+1)*3;
	var diffNiv=(niv-nivJ/2);
	var accNiv=Math.exp(-(nivJ/10));
	if (diffNiv<1) {diffNiv=1;}
	timeMax=tpsLong*diffNiv*accNiv+(aff.length)+1;
	timeLeft=timeMax;
	
	byId("labelNiv").innerHTML=niv;
	for (let o of aff) {
		switch (o.t) {
			case 'sed':
				sedim (canvG,o.h,o.c);
				break;
			case 'fn1':
				failleN (canvG,o.x,o.p,o.h);
				break;
			case 'fi1':
				failleI (canvG,o.x,o.p,o.h);
				break;
			case 'fn2':
				failleN2 (canvG,o.x,o.p,o.h);
				break;
			case 'fi2':
				failleI2 (canvG,o.x,o.p,o.h);
				break;
			case 'vol':
				volcan (canvG,o.x,o.p);
				break;
			case 'pli':
				ondule(canvG);
				break;
			case 'ero':
				erode (canvG,o.h);
				break;
			case 'plu':
				pluton (canvG,o.x,o.p,o.r);
			default:

		}
	}
	initSeeds();
	phase=1;
}


function annuleDernier () {
	if (tActions[1].length==0) {return false;}
	let gommes;
	if (!modeLibre) {
		gommes=joueur.readGommes();
		if (gommes<=0) {return false;}
		joueur.downGommes();
		updateVies();
	}
	tActions[1].pop();
	rebuildFromActions (1);
}


function rebuildFromActions (n) {
	videCanv(canvTemp);
	initSeeds();
	reinit(canvD);
	phase=2; // pour éviter de réécrire les actions
	tActions[2]=[];
	let canv;
	if (n==0) {canv=canvG;} else {canv=canvD;}
	for (act of tActions[n]) {
		let actR=act.substr(0, 3);
		switch (actR) {
			case 'sed':
				let c=act.substr(3,act.length-3);
				sedim (canv,10,c);
				break;
			case 'fn1':
				failleN (canv,-1,0.2,5);
				break;
			case 'fi1':
				failleI (canv,-1,0.2,5);
				break;
			case 'fn2':
				failleN2 (canv,-1,0.2,5);
				break;
			case 'fi2':
				failleI2 (canv,-1,0.2,5);
				break;
			case 'vol':
				volcan (canv,-1,-1);
				break;
			case 'pli':
				ondule(canv);
				break;
			case 'ero':
				erode (canv,5.5);
				break;
			case 'plu':
				pluton (canv,-1,-1,15);
			default:

		}
	}
	phase=1;
}


function disableBut (id) {
	let d=byId(id);
	d.style.opacity=0.5;
	d.style.pointerEvents="none";
}

function enableBut (id) {
	let d=byId(id);
	d.style.opacity=1;
	d.style.pointerEvents="auto";
}

function zeroTest(element) {
  return element === 0;
}


function videDansLigne (ct,n) {
	let alphaChan = ct.getImageData(0,n,lCanv,1).data.filter(function(element, index, array) {
			return (index % 4 === 3);
		});
	return alphaChan.indexOf (0);
}

function lowerYatX (c,x) {
	// point le plus bas contenant 1 0 à x
	let ct = c.getContext('2d');
	let i1=0;
	let i2=(hCanv-1);
	let i3;
	let pix;
	x=Math.round(x/100*lCanv);
	while (i2!=i1) {
		i3=Math.floor((i1+i2)/2);
		pix = ct.getImageData(x,i3,1,1).data[3];
		if (pix>0) { // au moint un pixel opaque
			i2=i3;
		} else {
			i1=i3+1;
		}
	}
	return i1;
}

function higherY (c) {
	// point le plus haut contenant au moins 1 pixel opaque
	let dx=Math.ceil(lCanv*0.09)+1; // 8% de marge de chaque côté
	let ct = c.getContext('2d');
	let i1=0;
	let i2=(hCanv-1);
	let i3;
	let alphaChan;
	while (i2!=i1) {
		i3=Math.floor((i1+i2)/2);
		alphaChan = ct.getImageData(dx,i3,lCanv-dx*2,1).data.filter(function(element, index, array) {
			return (index % 4 === 3);
		});
		let atLeastOpaque = alphaChan.some(a => a>0);
		if (atLeastOpaque) { // au moint un pixel opaque
			i2=i3;
		} else {
			i1=i3+1;
		}
	}
	return i1;
}


function lowerY (c) {
	// point le plus bas contenant au moins 1 zero
	let dx=Math.ceil(lCanv*0.09)+1; // 8% de marge de chaque côté
	let ct = c.getContext('2d');
	let i1=0;
	let i2=(hCanv-1);
	let i3;
	let alphaChan;
	while (i2!=i1) {
		i3=Math.floor((i1+i2)/2);
		alphaChan = ct.getImageData(dx,i3,lCanv-dx*2,1).data.filter(function(element, index, array) {
			return (index % 4 === 3);
		});
		if (alphaChan.indexOf (0)==-1) { // tous les pixels de la ligne sont opaques
			i2=i3;
		} else {
			i1=i3+1;
		}
	}
	return i1;
}

function redim () {
	let visi=divMain.style.display;
	divMain.style.display="block";
	lMain=divMain.clientWidth;
	hMain=divMain.clientHeight;
	var hFont=Math.round(lMain*1.5)/100;
	document.body.style.fontSize=hFont+"px";
	divMain.style.display=visi;
}


function random(seed) {
    var x = Math.sin(seed) * 10000;
    return x - Math.floor(x);
}


function anim () {
	if (modeLibre) {return false}
	if (!noTime) {diminueTemps();}
	if ((!defiFou)&&(phase==1)&&(byId("divLyellParle").style.display=="none")) {
		let next=nextGoodAction();
		if (hintValid) {
			if (next=="valide") {
				positionneDoigtSur("butComp");
				hintValid=false;
			}
		}
		
		if (hintSedim) {
			let firstSed=tActions[0][0][3];
			positionneDoigtSur("butSedim"+firstSed);
		}
		
		if (hintPli) {
			if (next=="pli") {
				positionneDoigtSur("butPli");
			}
		}
		
		if (hintPluton) {
			if (next=="plu") {
				positionneDoigtSur("butPluton");
			}
		}
		
		if (hintVolcan) {
			if (next=="vol") {
				positionneDoigtSur("butVolcan");
			}
		}
		
		if (hintErosion) {
			if (next=="ero") {
				positionneDoigtSur("butEro");
			}
		}
		
		if (hintFaille) {
			if (next[0]=="f") {
				let nomBut="";
				if (next=="fn1") {nomBut="butFailleN";}
				else if (next=="fn2") {nomBut="butFailleN2";}
				else if (next=="fi1") {nomBut="butFailleI";}
				else if (next=="fi2") {nomBut="butFailleI2";}
				positionneDoigtSur(nomBut);
			}
		}
	}

	if ((byId("divVerif").style.display=="block")&&(document.hasFocus()===true)) {
		numVerifAff=1-numVerifAff;
		videCanv(canvComp);
		if (numVerifAff==0) {
			ctComp.drawImage(canvD,0,0);
		} else {
			ctComp.drawImage(canvG,0,0);
		}
	}
	setTimeout (anim,100);
}

function diminueTemps () {
	if (modeLibre) {return false}
	if (saveAff==true) {return false;}
	if (panelChoixNiv.style.display=="block") {return false;}
	if (byId("divLyellParle").style.display=="block") {return false;}
	if (byId("divVerif").style.display=="block") {return false;}
	timeLeft-=0.1;
	if (timeLeft<0) {
		timeLeft=0;
		callTimeOut();
		return false;
	}
	var v=timeLeft/timeMax;
	var r=255-Math.round(v*254);
	var g=Math.round(v*254);
	byId("divBarreTemps").style.width=Math.round(v*15000)/100+"%";
	byId("divBarreTemps").style.backgroundColor="rgb("+r+","+g+",0)";
}



function preloadImages () {
	if (iImage==1) {showId("divChargement");}
	if (iImage>=(tImages.length-1)) {return false;}
	if (iImage==11) {setTimeout(go2,50);}
	var img=new Image ();
	img.onload=function () {
		//console.log (this.src);
		tImagesCache.push(this);
		setTimeout(preloadImages,20);
	}
	img.src="images/"+tImages[iImage];
	iImage++;
}




function go () {
	let urlParams = parseURLParams(window.location.href)||[]; 
	modeLibre=(typeof(urlParams["libre"])!="undefined");
	document.body.style.display="block";
	preloadImages();
}

function testAffichagePluton () {
	// on trace un pluton sur un sédiment noir et on lit les pixels affichés pour voir si ça marche
	// ça ne marche pas sur certains navigateurs par défaut
	videCanv(canvG);
	var x=0;
	var y=0;
	var pix=ctG.getImageData(x,y,1,1).data;
	// le pixel 0,0 doit être transparent
	if ((pix[0]!=0)||(pix[1]!=0)||(pix[2]!=0)||(pix[3]!=0)) {return false;}
		
	sedim(canvG,100,8,true);
	pix=ctG.getImageData(x,y,1,1).data;
	// le pixel 0,0 doit être noir opaque
	if ((pix[0]!=0)||(pix[1]!=0)||(pix[2]!=0)||(pix[3]!=255)) {return false;}
	
	pluton (canvG,50,5,40,true);
	x=Math.round(lCanv/2);
	y=0;
	pix=ctG.getImageData(x,y,1,1).data;
	// le pixel 50%,0 doit correspondre au halo du pluton
	if ((pix[0]<50)||(pix[3]<255)) {return false;}
	return true;
}


function go2() {
	joueur=new pJoueur();
	hideId("divChargement");
	showId ("divMain");
	initAff ();
	initDiv();
	
	redim();
	
	if (!modeLibre) {
		disableBut("butEro");
		disableBut("butPli");
		disableBut("butFailleN");
		disableBut("butFailleN2");
		disableBut("butFailleI");
		disableBut("butFailleI2");
		disableBut("butPluton");
		disableBut("butVolcan");
	}
	if (testAffichagePluton()===true) {
		anim();
		if (!modeLibre) {
			if (!noIntro) {	afficheConseil (-3); }
			initSituation (getnAleaInNiv (1)) ;
			updateVies();
		} else {
			initModeLibre ();
		}
		
	} else {
		afficheConseil (-4);
	}
}

function initModeLibre() {
	show(divTexteModeLibre);
	hide(divLienModeLibre);
	divTexteModeLibre.innerHTML="<h1 style='text-align:center'>Mode libre</h1><br><p>Dans ce mode vous pouvez construire librement votre affleurement en utilisant les boutons du panneau central.</p><br><p>Le bouton 'Annuler' permet d'annuler la dernière action, le bouton 'Recommencer' permet de créer un nouvel affleurement.</p><br><p><a href='index.htm'>Cliquer ici pour revenir au mode jeu.</a></p>";
	hide(divTemps);
	hide(divScore);
	hide(divNiveauJ);
	hide(divNomNiveau);
	hide(divAmmonites);
	hide(divGommes);
	hide(divVies);
	hide(butComp);
	hide(butSkip);
	hide(divMap);
	hide(canvG);
	initSituation(0);
}

function positionneDoigtSur (nomDiv) {
	lastHint=nomDiv;
	if (defiFou) {return false;}
	let but=byId(nomDiv);
	let box=getPosInMain (but,true);
	byId("divDoigt").style.left=box.x+"px";
	byId("divDoigt").style.top=box.y+"px";
	showId("divDoigt");
}

function parseURLParams(url) {
    var queryStart = url.indexOf("?") + 1,
        queryEnd   = url.indexOf("#") + 1 || url.length + 1,
        query = url.slice(queryStart, queryEnd - 1),
        pairs = query.replace(/\+/g, " ").split("&"),
        parms = {}, i, n, v, nv;

    if (query === url || query === "") {
        return;
    }

    for (i = 0; i < pairs.length; i++) {
        nv = pairs[i].split("=");
        n = decodeURIComponent(nv[0]);
        v = decodeURIComponent(nv[1]);

        if (!parms.hasOwnProperty(n)) {
            parms[n] = [];
        }

        parms[n].push(nv.length === 2 ? v : null);
    }
    return parms;
}
